#ifndef DEFS_H
#define DEFS_H


#include <stdio.h>
#include <stdlib.h>

typedef unsigned int uint;
typedef unsigned long long u64;

using namespace std;

//#define DEBUG
//#define DEEPDEBUG

//eval items
const uint OPE = 0;//phase
const uint END = 1;

const int belowmate = -32768;
const int matescore = 32768;
inline bool scoreok(int s) { return (s>=belowmate && s<= matescore) ? true : false; }
inline int cpscore(int s) { return ((s*100)/256); }

const int NOSET = 9999; //for the time controller


const int N = 16;
const int NW = 15;
const int NE = 17;
const int E = 1;
const int W = -1;
const int S = -16;
const int SE = -15;
const int SW = -17;

//knight directions
const int NNW = N+N+W;
const int NNE = N+N+E;
const int NEE = N+E+E;
const int NWW = N+W+W;
const int SSW = S+S+W;
const int SSE = S+S+E;
const int SEE = S+E+E;
const int SWW = S+W+W;

/*
from and to, seven bits each
cap piece, prom piece 4 bits each
flag ep,castle = 2bits

Total 24 bits
0000 0000 0000 0000 0111 1111 from
0000 0000 0011 1111 1000 0000 to
0000 0000 0100 0000 0000 0000 ep
0000 0000 1000 0000 0000 0000 ca
0000 1111 0000 0000 0000 0000 cappiece
1111 0000 0000 0000 0000 0000 prompiece
*/
//move inlines for to from sq, capture piece and prom piece and flag
const uint FlagEP = 0x4000;
const uint FlagCA = 0x8000;
const uint FlagE = 0x00;
const uint FlagCAPEP = (FlagEP | 0xf0000);

const uint NULLMOVE = 0xffff;

const uint maxply = 48;
const uint nomove = 0;
const uint maxmoves = 512; // max number of moves in a position
const uint maxgamelength = 1024;

inline uint FROM(uint &sq) { return (sq & 0x7f); }
inline uint TO(uint &sq) { return ((sq & 0x3f80)>>7); }
inline uint FLAG(uint &sq) { return (sq & 0xc000); }
inline uint CAP(uint &sq) { return ((sq & 0xf0000)>>16); }
inline uint PROM(uint &sq) { return ((sq & 0xf00000)>>20); }


const uint tFlagUPPER = 4;
const uint tFlagLOWER = 2;
const uint tFlagEXACT = 1;
const uint tFlagNOTSET = 8;



// taken from "C++ Promgramming In Easy Steps"
extern inline void inline_assert(const char *expr, bool result, const char *file, int line)
{
    if (!result)
   {
       cout<<" assertion *: "<< expr << " :* fails!! " << endl
       << "File: " << file << " line: " << line << endl;
   }
}

#ifdef DEBUG
#define ASS(expr) inline_assert(#expr, (expr), __FILE__, __LINE__)
#else
#define  ASS(exp)
#endif

#endif
